<?php include '../header.php'; ?>
<?php include '../sidebar.php'; ?>
<?php include '../content.php'; ?>

<h1>Box and Whisker Chart with Customization</h1>
<div id="chartContainer"></div>

<?php
    $dataPoints = array(
        array("label" => "Oven", "y" => array(4, 6, 8, 9, 7)),
        array("label" => "Microwawe", "y" => array(5, 6, 7, 8, 6.5)),
        array("label" => "PC & Peripherals", "y" => array(6, 8, 10, 11, 9.5)),
        array("label" => "Air Conditioner", "y" => array(8, 9, 13, 14, 10.5)),
        array("label" => "Dishwasher", "y" => array(5, 7, 9, 12, 7.5)),
        array("label" => "Electric Kettle", "y" => array(4, 6, 8, 9, 7)),
        array("label" => "Fridge", "y" => array(8, 9, 12, 13, 11))
    );
?>

<script>
    window.onload = function () {
        var chart = new CanvasJS.Chart("chartContainer", {
            theme: "light2",
            title: {
                text: "Energy Consumption",
                fontColor: "#3C4D2D"
            },
            axisY: {
                title: "Energy Consumption (in kWh)"
            },
            data: [{
                type: "boxAndWhisker",
                color: "#3C4D2D",
                upperBoxColor: "#AEF35A",
                lowerBoxColor: "#B8B2FB",
                yValueFormatString: "#,##0 kWh",
                dataPoints: <?php echo json_encode($dataPoints, JSON_NUMERIC_CHECK); ?>
            }]
        });
        chart.render();
    }
</script>

<?php include '../footer.php'; ?>